% GETAMPLEAREA Get the bounding box of all positions.
%
%	[XMIN,XMAX,YMIN,YMAX] = GETAMPLEAREA(DATA,BCCOORDS,POLYGONS,BYD)
%	returns the bounding box that include all positions from DATA (rss
%	measurements) BCCOORDS (beacons) and POLYGONS (obstacles), buffered out
%	by BYD units.
%
%   See Also PLOTTHEMALL.
%
%   Copyright  2018 Universitat Jaume I (UJI)

% Permission is hereby granted, free of charge, to any person obtaining a copy of
% this software and associated documentation files (the "Software"), to deal in
% the Software without restriction, including without limitation the rights to
% use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
% of the Software, and to permit persons to whom the Software is furnished to do
% so, subject to the following conditions:
%
% The above copyright notice and this permission notice shall be included in all
% copies or substantial portions of the Software.
%
% THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
% IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
% FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
% AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
% LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
% OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
% SOFTWARE.

function [area] = getAmpleArea(set)
   if (set.id==1 || set.id ==2)
       
       load("dataPhysics.mat");
       
       % Floor 0
       area0 = 0;   
       X = [];
       Y = [];
       for i=1:1:size(dataPhysics.room,2)
           room = dataPhysics.room(i);
           if (room.Z1 <1)
              X = [X room.X1 room.X2]; 
              Y = [Y room.Y1 room.Y2];   
           end
       end
       area0 = (max(X)-min(X))*(max(Y)-min(Y));
       
       % Floor 1
       area1 = 0;   
       X = [];
       Y = [];
       for i=1:1:size(dataPhysics.room,2)
           room = dataPhysics.room(i);
           if ((room.Z1 <5) && (room.Z1 > 2))
              X = [X room.X1 room.X2]; 
              Y = [Y room.Y1 room.Y2];   
           end
       end
       area0 = (max(X)-min(X))*(max(Y)-min(Y));
       
       % Floor 2
       area2 = 0;   
       X = [];
       Y = [];
       for i=1:1:size(dataPhysics.room,2)
           room = dataPhysics.room(i);
           if ((room.Z1 <9) && (room.Z1 > 5))
              X = [X room.X1 room.X2]; 
              Y = [Y room.Y1 room.Y2];   
           end
       end
       area2 = (max(X)-min(X))*(max(Y)-min(Y));
       area =area1+area2+area0;

   elseif (set.id ==3)
       
   load("dataPhysics.mat");
       
       % Floor 0
       area0 = 0;   
       X = [];
       Y = [];
       for i=1:1:size(dataPhysics.room,2)
           room = dataPhysics.room(i);
           if (room.Z1 <1)
              X = [X room.X1 room.X2]; 
              Y = [Y room.Y1 room.Y2];   
           end
       end
       area0 = (max(X)-min(X))*(max(Y)-min(Y));
       
       % Floor 1
       area1 = 0;   
       X = [];
       Y = [];
       for i=1:1:size(dataPhysics.room,2)
           room = dataPhysics.room(i);
           if ((room.Z1 <5) && (room.Z1 > 2))
              X = [X room.X1 room.X2]; 
              Y = [Y room.Y1 room.Y2];   
           end
       end
       area0 = (max(X)-min(X))*(max(Y)-min(Y));
       
       % Floor 2
       area2 = 0;   
       X = [];
       Y = [];
       for i=1:1:size(dataPhysics.room,2)
           room = dataPhysics.room(i);
           if ((room.Z1 <9) && (room.Z1 > 5))
              X = [X room.X1 room.X2]; 
              Y = [Y room.Y1 room.Y2];   
           end
       end
       area2 = (max(X)-min(X))*(max(Y)-min(Y));
       area =area1+area2+area0;
       
       load("dataMathematics.mat");
       
       % Floor 0
       area0m = 0;   
       X = [];
       Y = [];
       for i=1:1:size(dataMathematics.room,2)
           room = dataMathematics.room(i);
           if (room.Z1 <1)
              X = [X room.X1 room.X2]; 
              Y = [Y room.Y1 room.Y2];   
           end
       end
       area0m = (max(X)-min(X))*(max(Y)-min(Y));
       
       % Floor 1
       area1m = 0;   
       X = [];
       Y = [];
       for i=1:1:size(dataMathematics.room,2)
           room = dataMathematics.room(i);
           if ((room.Z1 <5) && (room.Z1 > 2))
              X = [X room.X1 room.X2]; 
              Y = [Y room.Y1 room.Y2];   
           end
       end
       area1m = (max(X)-min(X))*(max(Y)-min(Y));
       
       % Floor 2
       area2m = 0;   
       X = [];
       Y = [];
       for i=1:1:size(dataMathematics.room,2)
           room = dataMathematics.room(i);
           if ((room.Z1 <9) && (room.Z1 > 5))
              X = [X room.X1 room.X2]; 
              Y = [Y room.Y1 room.Y2];   
           end
       end
       area2m = (max(X)-min(X))*(max(Y)-min(Y));
       aream =area1m+area2m+area0m;
       
       area = area +aream;
       
   
end
   
    
    
end